import { useQuery } from "react-query";
import axios from "axios";
import Cookies from "js-cookie";
import { useAppDispatch } from "../../utils/hooks";
import { StoryListRes } from "../../types/StatusTypes";
import { updateStoryListRes } from "../Slices/StatusSlice";

export const useStatusList = () => {
  const token = Cookies.get("whoxa_web_token");
  const dispatch = useAppDispatch();

  return useQuery<StoryListRes, Error>(
    ["/story/get-stories"],
    async () => {
      const response = await axios.get<StoryListRes>(
        `${import.meta.env.VITE_API_URL}story/get-stories`,
        {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        },
      );
      dispatch(updateStoryListRes(response.data));
      return response.data;
    },
    {
      // Set cache time to prevent re-fetching on route changes
      staleTime: Infinity, // Data will never be considered stale
      cacheTime: Infinity, // Data will never be removed from cache
    },
  );
};
