export interface BlockUserListRes {
  status:  boolean;
  data:    Data;
  message: string;
  toast:   boolean;
}

export interface Data {
  Records:    Record[];
  Pagination: Pagination;
}

export interface Pagination {
  total_pages:      number;
  total_records:    number;
  current_page:     number;
  records_per_page: number;
}

export interface Record {
  block_id:        number;
  approved:        boolean;
  createdAt:       Date;
  updatedAt:       Date;
  user_id:         number;
  blocked_id:      number;
  blocked_chat_id: null;
  blocked:         Blocked;
}

export interface Blocked {
  user_name:                   string;
  email:                       string;
  mobile_num:                  string;
  profile_pic:                 string;
  selfie:                      string;
  dob:                         string;
  user_id:                     number;
  first_name:                  string;
  last_name:                   string;
  full_name:                   string;
  country_code:                string;
  socket_ids:                  string[];
  otp:                         number;
  password:                    string;
  login_type:                  string;
  gender:                      string;
  country:                     string;
  country_short_name:          string;
  state:                       string;
  city:                        string;
  bio:                         string;
  device_token:                string;
  profile_verification_status: boolean;
  login_verification_status:   boolean;
  is_private:                  boolean;
  is_admin:                    boolean;
  platforms:                   string[];
  deleted_at:                  null;
  bloked_by_admin:             boolean;
  contact_details:             ContactDetail[];
  createdAt:                   Date;
  updatedAt:                   Date;
}

export interface ContactDetail {
  name:    string;
  number:  string;
  user_id: number;
}
