export interface ChatListRes {
  pagination: Pagination;
  Chats: OuterChat[];
}

export interface OuterChat {
  Records: Record[];
  PeerUserData: PeerUserData;
}

export interface PeerUserData {
  user_name: string;
  email: string;
  mobile_num?: string;
  profile_pic: string;
  user_id: number;
  full_name: string;
  country_code: string;
  country: string;
  gender: Gender;
  bio: string;
  profile_verification_status: boolean;
  login_verification_status: boolean;
  socket_ids: string[];
  updatedAt?: Date;
  createdAt?: Date;
}

export enum Gender {
  GenderMale = "male",
  Male = "Male",
}

export interface Record {
  group_icon: string;
  chat_id: number;
  chat_type: "group" | "private";
  group_name: string;
  group_description: string;
  deleted_at: Date | null;
  is_group_blocked: boolean;
  archived_for: string[];
  blocked_by: string[];
  cleared_for: string[];
  deleted_for: string[];
  createdAt: Date;
  updatedAt: Date;
  deletedAt: Date | null;
  Messages: Message[];
  unseen_count: number;
}

export interface Message {
  message_content: string;
  message_thumbnail: string;
  reply_to: number;
  social_id: number;
  message_id: number;
  message_type:
    | "text"
    | "image"
    | "gif"
    | "video"
    | "audio"
    | "file"
    | "link"
    | "call"
    | "member-added"
    | "member-removed"
    | "promoted-as-admin"
    | "group-created"
    | "member-left"
    | "removed-as-admin"
    | "block"
    | "doc"
    | "location"
    | "poll"
    | "contact";
  message_length: string;
  message_seen_status: string;
  message_size: string;
  deleted_for: string[];
  starred_for: string[];
  deleted_for_everyone: boolean;
  pinned: boolean;
  pin_lifetime: string | null;
  peer_user: PeerUserData | null;
  pinned_till: string | null;
  forwarded_from: number;
  createdAt: Date;
  updatedAt: Date;
  chat_id: number;
  sender_id: number | null;
  User: PeerUserData | null;
  ActionedUser: PeerUserData | null;
  Calls: Call[];
}

export interface Call {
  call_id: number;
  call_type: string;
  call_status: string;
  call_duration: number;
  start_time: Date;
  end_time: Date;
  users: string[];
  current_users: string[];
  room_id: string;
  createdAt: Date;
  updatedAt: Date;
  message_id: number;
  chat_id: number;
  user_id: number;
  caller: Caller;
}

export interface Caller {
  user_name: string;
  email: string;
  profile_pic: string;
  user_id: number;
  full_name: string;
  country_code: string;
  country: string;
  gender: string;
}

export interface Pagination {
  total_pages: number;
  total_records: number;
  current_page: number;
  records_per_page: number;
}

export interface CurrentConversationType {
  chat_id: number;
  chat_type: "group" | "private";
  full_name: string;
  group_name?: string;
  group_description?: string;
  group_icon?: string;
  mobile_num?: string;
  profile_pic?: string;
  createdAt?: Date;
  updatedAt?: Date;
  user_id?: number;
  user_name?: string;
  email_id?: string;
  is_group_blocked?: boolean;
  other_user_blocked_you?: boolean;
  unseen_count?: number;
  bio?: string;
  is_message_list_empty?: boolean;
  is_archived?: boolean;
  is_conversation_changed?: number;
}
