export interface MessageListRes {
  pinned_messages: MessageList;
  message_list: MessageList;
}

export interface MessageList {
  Records: Message[];
  Pagination: Pagination;
}

export interface Pagination {
  total_pages: number;
  total_records: number;
  current_page: number;
  records_per_page: number;
}

export interface Message {
  message_content: string;
  message_thumbnail: string;
  reply_to: number;
  social_id: number;
  message_id: number;
  message_type:
  | "text"
  | "image"
  | "video"
  | "gif"
  | "audio"
  | "file"
  | "contact"
  | "location"
  | "doc"
  | "link"
  | "call"
  | "member-added"
  | "member-removed"
  | "promoted-as-admin"
  | "group-created"
  | "member-left"
  | "removed-as-admin"
  | "block"
  | "story_reply";
  message_length: string;
  message_seen_status: "seen" | "sent";
  message_size: string;
  deleted_for: number[];
  starred_for: number[];
  deleted_for_everyone: boolean;
  pinned: boolean;
  pin_lifetime: null;
  peer_user: number | null;
  pinned_till: null;
  forwarded_from: number;
  createdAt: Date;
  updatedAt: Date;
  chat_id: number;
  sender_id: number;
  ParentMessage?: Message | null;
  Replies: Message[];
  User: MessageUser;
  ActionedUser: MessageUser | null;
  starred: boolean;
  Calls: Call[];
  Story: Story;
}

export interface Call {
  call_id: number;
  call_type: string;
  call_status: string;
  call_duration: number;
  start_time: Date;
  end_time: Date;
  users: string[];
  current_users: string[];
  room_id: string;
  createdAt: Date;
  updatedAt: Date;
  message_id: number;
  chat_id: number;
  user_id: number;
  caller: Caller;
}

export interface Caller {
  user_name: string;
  email: string;
  profile_pic: string;
  user_id: number;
  full_name: string;
  country_code: string;
  country: string;
  gender: string;
}

export interface MessageUser {
  user_name: string;
  email: string;
  profile_pic: string;
  user_id: number;
  full_name: string;
  country_code: string;
  country: string;
  gender: string;
  bio: string;
  profile_verification_status: boolean;
  login_verification_status: boolean;
  socket_ids: string[];
}

export interface Story {
  media: string;
  thumbnail: string;
  story_id: number;
  caption: string;
  story_type: string;
  expiresAt: Date;
  tagged: any[];
  views: any[];
  is_expired: boolean;
  createdAt: Date;
  updatedAt: Date;
  user_id: number;
  user: StoryUser;
}

export interface StoryUser {
  user_name: string;
  email: string;
  profile_pic: string;
  user_id: number;
  full_name: string;
  country_code: string;
  country: string;
  gender: string;
  bio: string;
  profile_verification_status: boolean;
  login_verification_status: boolean;
  socket_ids: string[];
}


// Search Message Res ==================================================================================
export interface SearchResultRes {
  success: boolean;
  message: string;
  searchResults: SearchResult[];
}

export interface SearchResult {
  url: string;
  thumbnail: string;
  message_id: number;
  message: string;
  message_type: string;
  who_seen_the_message: string;
  delete_from_everyone: boolean;
  delete_for_me: string;
  message_seen_status: "seen" | "sent";
  video_time: string;
  audio_time: string;
  latitude: string;
  longitude: string;
  shared_contact_name: string;
  shared_contact_profile_image: string;
  shared_contact_number: string;
  forward_id: number;
  reply_to: number;
  status_id: number;
  createdAt: Date;
  updatedAt: Date;
  senderId: number;
  chat_id: number;
  User: User;
}

export interface User {
  profile_image: string;
  user_id: number;
  mobile_num: string;
  user_name: string;
  first_name: string;
  last_name: string;
}