export interface VerifyOtpRes {
  status: boolean;
  data: Data;
  message: string;
  toast: boolean;
}

export interface Data {
  token: string;
  user: User;
}

export interface User {
  user_name: string;
  email: string;
  mobile_num: string;
  profile_pic: string;
  selfie: string;
  dob: string;
  user_id: number;
  first_name: string;
  last_name: string;
  full_name: string;
  country_code: string;
  socket_ids: string[];
  otp: number;
  password: string;
  login_type: string;
  gender: string;
  country: string;
  country_short_name: string;
  state: string;
  city: string;
  bio: string;
  device_token: string;
  profile_verification_status: boolean;
  login_verification_status: boolean;
  is_private: boolean;
  is_admin: boolean;
  platforms: string[];
  deleted_at: null;
  bloked_by_admin: boolean;
  contact_details: string[];
  createdAt: Date;
  updatedAt: Date;
}

// Update Group Response ==================================================================================
export interface UpdateGroupRes {
  status: boolean;
  data: UpdateGroupData;
  message: string;
  toast: boolean;
}

export interface UpdateGroupData {
  group_icon: string;
  chat_id: number;
  chat_type: string;
  group_name: string;
  group_description: string;
  deleted_at: null;
  is_group_blocked: boolean;
  archived_for: string[];
  blocked_by: string[];
  cleared_for: string[];
  deleted_for: string[];
  createdAt: Date;
  updatedAt: Date;
  deletedAt: null;
}

// Avtar list response ==================================================================================
export interface AvatarListRes {
  status: boolean;
  data: AvtarData;
  message: string;
  toast: boolean;
}

export interface AvtarData {
  Records: AvtarRecord[];
}

export interface AvtarRecord {
  avatar_media: string;
  avatar_id: number;
  name: string;
  avatar_gender: AvatarGender;
  status: boolean;
  createdAt: Date;
  updatedAt: Date;
}

export enum AvatarGender {
  Female = "female",
  Male = "male",
}

// Group Settings ==================================================================================
export interface GroupSettingsRes {
  success: boolean;
  message: string;
  settings: Setting[];
}

export interface Setting {
  setting_id: number;
  max_members: number;
  createdAt: Date;
  updatedAt: Date;
}

// Report-type-list ==================================================================================

export interface ReportTypeRes {
  status: boolean;
  data: ReportTypeData;
  message: string;
  toast: boolean;
}

export interface ReportTypeData {
  ReportTypes: ReportType[];
}

export interface ReportType {
  report_type_id: number;
  report_text: string;
  report_for: string;
  createdAt: Date;
  updatedAt: Date;
}

// WebsiteSettingsRes ==================================================================================
export interface WebsiteSettingsRes {
  status: boolean;
  data: WebsiteSettingsData;
  message: string;
  toast: boolean;
}

export interface WebsiteSettingsData {
  app_logo_light: string;
  app_logo_dark: string;
  one_signal_api_key: string;
  web_logo_light: string;
  web_logo_dark: string;
  twilio_account_sid: string;
  twilio_auth_token: string;
  twilio_phone_number: string;
  password: string;
  email_banner: string;
  config_id: number;
  phone_authentication: boolean;
  email_authentication: boolean;
  maximum_members_in_group: number;
  show_all_contatcts: boolean;
  show_phone_contatcs: boolean;
  one_signal_app_id: string;
  android_channel_id: string;
  app_name: string;
  app_email: string;
  app_text: string;
  app_primary_color: string;
  app_secondary_color: string;
  app_ios_link: string;
  app_android_link: string;
  app_tell_a_friend_text: string;
  email_service: string;
  smtp_host: string;
  email: string;
  email_title: string;
  copyright_text: string;
  privacy_policy: string;
  terms_and_conditions: string;
  createdAt: Date;
  updatedAt: Date;
}

// Privacy Policy ==================================================================================
export interface PrivacyPolicyRes {
  success: boolean;
  message: string;
  privacy_policy: PrivacyPolicy[];
}

export interface PrivacyPolicy {
  id: number;
  Link: string;
  createdAt: Date;
  updatedAt: Date;
}
// Terms and Condition ==================================================================================
export interface TermsAndConditionRes {
  success: boolean;
  message: string;
  TandCs: TandC[];
}

export interface TandC {
  id: number;
  Link: string;
  createdAt: Date;
  updatedAt: Date;
}

// Language Listres ==================================================================================

export interface LanguageListRes {
  status: boolean;
  data: Data;
  message: string;
  toast: boolean;
}

export interface Data {
  Records: Language[];
  Pagination: Pagination;
}

export interface Language {
  language_id: number;
  language: string;
  language_alignment: string;
  country: string;
  status: boolean;
  default_status: boolean;
  createdAt: Date;
  updatedAt: Date;
}

// Pin Message list res ==================================================================================
export interface PinMessageListRes {
  success: boolean;
  message: string;
  PinMessageList: PinMessageList[];
}

export interface PinMessageList {
  pin_message_id: number;
  duration: string;
  expires_at: Date | null;
  createdAt: Date;
  updatedAt: Date;
  message_id: number;
  chat_id: number;
  user_id: number;
  Chat: Chat;
  other_user_id: number;
  otherUserDetails: User[];
}

export interface Chat {
  url: string;
  thumbnail: string;
  message_id: number;
  message: string;
  message_type?:
  | "image"
  | "video"
  | "text"
  | "link"
  | "location"
  | "doc"
  | "audio"
  | "contact"
  | "status"
  | "gif"
  | "date"
  | "video"
  | "audio"
  | "member_added"
  | "member_removed"
  | "delete_from_everyone"
  | "";
  who_seen_the_message: string;
  delete_from_everyone: boolean;
  delete_for_me: string;
  message_seen_status: "seen" | "sent";
  video_time: string;
  audio_time: string;
  latitude: string;
  longitude: string;
  shared_contact_name: string;
  shared_contact_profile_image: string;
  shared_contact_number: string;
  forward_id: number;
  reply_to: number;
  status_id: number;
  createdAt: Date;
  updatedAt: Date;
  senderId: number;
  chat_id: number;
  User: User;
  Conversation: Conversation;
}

export interface Conversation {
  group_profile_image: string;
  chat_id: number;
  is_group: boolean;
  group_name: string;
}

export interface User {
  profile_image: string;
  user_id: number;
  mobile_num: string;
  first_name: string;
  last_name: string;
  user_name: string;
}

// PublicGroup res ==================================================================================
export interface AllPublicGroupRes {
  success: boolean;
  message: string;
  allPublicGroup: AllPublicGroup[];
  pagination: Pagination;
}

export interface AllPublicGroup {
  group_profile_image: string;
  chat_id: number;
  is_group: boolean;
  group_name: string;
  last_message: string;
  last_message_id: number;
  last_message_type: string;
  blocked_by_admin: boolean;
  created_by_admin: boolean;
  public_group: boolean;
  createdAt: Date;
  updatedAt: Date;
}

export interface Pagination {
  count: number;
  currentPage: number;
  totalPages: number;
}

// ConnectedUserList ==================================================================================
export interface ConnectedUserListRes {
  connectedUsers: ConnectedUser[];
}

export interface ConnectedUser {
  profile_image: string;
  user_id: number;
  full_name: string;
  user_name: string;
}

// CallData ==================================================================================
export interface CallData {
  senderId: number;
  receiver_token: string;
  one_signal_player_id: string;
  call_type: string;
  missed_call: boolean;
  sender_phone_number: string;
  senderName: string;
  sender_profile_image: string;
  is_group: boolean;
  room_id: string;
  sender_first_name: string;
  receiver_profile_image: string;
  receiver_phone_number: string;
  receiverId: number;
  message_id: number;
  call_id: number;
  chat_id: string;
}

//  CallListRes ==================================================================================
export interface CallUserRes {
  success: boolean;
  call: Call;
  user: User;
}

export interface Call {
  call_id: number;
  call_type: string;
  call_status: string;
  call_duration: number;
  start_time: Date;
  end_time: Date;
  users: string[];
  message_id: number;
  chat_id: number;
  user_id: number;
  room_id: string;
  current_users: string[];
  updatedAt: Date;
  createdAt: Date;
  caller_name: string;
}

export interface User {
  user_name: string;
  email: string;
  mobile_num: string;
  profile_pic: string;
  selfie: string;
  dob: string;
  user_id: number;
  first_name: string;
  last_name: string;
  full_name: string;
  country_code: string;
  socket_ids: string[];
  country: string;
  country_short_name: string;
  state: string;
  city: string;
  bio: string;
  device_token: string;
  profile_verification_status: boolean;
  login_verification_status: boolean;
  is_private: boolean;
  is_admin: boolean;
  deleted_at: null;
  bloked_by_admin: boolean;
  createdAt: Date;
  updatedAt: Date;
}

// FetchUserRes ==================================================================================
export interface FetchUserRes {
  status: boolean;
  data: Data;
  message: string;
  toast: boolean;
}

export interface Data {
  Records: FetchUser[];
  Pagination: Pagination;
}

export interface FetchUser {
  user_name: string;
  email: string;
  profile_pic: string;
  updatedAt: Date;
  user_id: number;
  full_name: string;
  country_code: string;
  country: string;
  gender: string;
  bio: string;
  profile_verification_status: boolean;
  login_verification_status: boolean;
  first_name: string;
  last_name: string;
}

export interface DeleteForEveryoneRes {
  message_content: string;
  message_thumbnail: string;
  reply_to: number;
  social_id: number;
  message_id: number;
  message_type: string;
  message_length: string;
  message_seen_status: string;
  message_size: string;
  deleted_for: string[];
  starred_for: string[];
  deleted_for_everyone: boolean;
  pinned: boolean;
  pin_lifetime: null;
  peer_user: null;
  pinned_till: null;
  forwarded_from: number;
  createdAt: Date;
  updatedAt: Date;
  chat_id: number;
  sender_id: number;
}

// pinned_unpinned_message ==================================================================================
export interface PinUnpinRes {
  Records: PinUnpin[];
}

export interface PinUnpin {
  message_content: string;
  message_thumbnail: string;
  reply_to: number;
  social_id: number;
  message_id: number;
  message_type: string;
  message_length: string;
  message_seen_status: string;
  message_size: string;
  deleted_for: string[];
  starred_for: string[];
  deleted_for_everyone: boolean;
  pinned: boolean;
  pin_lifetime: number;
  peer_user: null;
  pinned_till: null;
  forwarded_from: number;
  createdAt: Date;
  updatedAt: Date;
  chat_id: number;
  sender_id: number;
}

// real_time_message_seen ==================================================================================
export interface RealTimeMessageSeenRes {
  message_content: string;
  message_thumbnail: string;
  reply_to: number;
  social_id: number;
  message_id: number;
  message_type: string;
  message_length: string;
  message_seen_status: string;
  message_size: string;
  deleted_for: string[];
  starred_for: string[];
  deleted_for_everyone: boolean;
  pinned: boolean;
  pin_lifetime: null;
  peer_user: null;
  pinned_till: null;
  forwarded_from: number;
  createdAt: Date;
  updatedAt: Date;
  chat_id: number;
  sender_id: number;
}

// media_doc_links ==================================================================================
export interface MediaDocLinksRes {
  status: boolean;
  data: MediaDocLinksData;
  message: string;
  toast: number;
}

export interface MediaDocLinksData {
  Records: MediaDocLinksRecord[];
  pagenation: Pagenation;
}

export interface MediaDocLinksRecord {
  message_content: string;
  message_thumbnail: string;
  reply_to: number;
  social_id: number;
  message_id: number;
  message_type: string;
  message_length: string;
  message_seen_status: string;
  message_size: string;
  deleted_for: string[];
  starred_for: string[];
  deleted_for_everyone: boolean;
  pinned: boolean;
  pin_lifetime: null;
  peer_user: null;
  pinned_till: null;
  forwarded_from: number;
  createdAt: Date;
  updatedAt: Date;
  chat_id: number;
  sender_id: number;
}

export interface Pagenation {
  total_records: number;
  current_page: number;
  records_per_page: number;
  total_pages: number;
}

export interface GroupMemberRes {
  status: boolean;
  data: GroupMemberData;
  message: string;
  toast: boolean;
}

export interface GroupMemberData {
  Records: GroupMemberRecord[];
}

export interface GroupMemberRecord {
  participant_id: number;
  is_admin: boolean;
  update_counter: boolean;
  is_deleted: boolean;
  last_message_id: number;
  is_creator: boolean;
  createdAt: Date;
  updatedAt: Date;
  chat_id: number;
  user_id: number;
  User: GroupUser;
}

export interface GroupUser {
  user_name: string;
  email: string;
  profile_pic: string;
  user_id: number;
  full_name: string;
  country_code: string;
  country: string;
}

// contact List ==================================================================================
export interface ContactListRes {
  status: boolean;
  data: ContactType[];
  message: string;
  toast: boolean;
}

export interface ContactType {
  name: string;
  number: string;
  user_id: number;
  user_name: string;
  updatedAt: Date;
  profile_pic: string;
}

// delete chat ==================================================================================
export interface GeneralRes {
  status: boolean;
  data: generalData;
  message: string;
  toast: number;
}

export interface generalData { }

export interface BlockUserRes {
  status: boolean;
  data: BlockUserData;
  message: string;
  toast: boolean;
}

export interface BlockUserData {
  is_blocked: boolean;
}

// create group ==================================================================================
export interface CreateGroupRes {
  status: boolean;
  data: createGroupData;
  message: string;
  toast: boolean;
}

export interface createGroupData {
  group_icon: string;
  group_description: string;
  is_group_blocked: boolean;
  archived_for: string[];
  blocked_by: string[];
  cleared_for: string[];
  deleted_for: string[];
  chat_id: number;
  chat_type: string;
  group_name: string;
  updatedAt: Date;
  createdAt: Date;
  deleted_at: null;
  deletedAt: null;
}

export interface SearchMessageRes {
  status: boolean;
  data: searchMessageData;
  message: string;
  toast: number;
}

export interface searchMessageData {
  Records: searchMessageRecord[];
  pagenation: Pagenation;
}

export interface searchMessageRecord {
  message_content: string;
  message_thumbnail: string;
  reply_to: number;
  social_id: number;
  message_id: number;
  message_type: string;
  message_length: string;
  message_seen_status: string;
  message_size: string;
  deleted_for: string[];
  starred_for: string[];
  deleted_for_everyone: boolean;
  pinned: boolean;
  pin_lifetime: null;
  peer_user: null;
  pinned_till: null;
  forwarded_from: number;
  createdAt: Date;
  updatedAt: Date;
  chat_id: number;
  sender_id: number;
  User: searchUser;
}
export interface searchUser {
  user_name: string;
  profile_pic: string;
  user_id: number;
  full_name: string;
}

export interface Pagenation {
  total_records: number;
  current_page: number;
  records_per_page: number;
  total_pages: number;
}

// user joined ==================================================================================
export interface UserJoinedRes {
  user: UserJoinedUser;
  call: UserJoinedCall;
  peer_id: string;
}

export interface UserJoinedCall {
  call_id: number;
  call_type: string;
  call_status: string;
  call_duration: number;
  start_time: Date;
  end_time: Date;
  users: string[];
  current_users: string[];
  room_id: string;
  createdAt: Date;
  updatedAt: Date;
  message_id: number;
  chat_id: number;
  user_id: number;
}

export interface UserJoinedUser {
  user_name: string;
  email: string;
  mobile_num: string;
  profile_pic: string;
  selfie: string;
  dob: string;
  user_id: number;
  first_name: string;
  last_name: string;
  full_name: string;
  country_code: string;
  socket_ids: string[];
  otp: number;
  password: string;
  login_type: string;
  gender: string;
  country: string;
  country_short_name: string;
  state: string;
  city: string;
  bio: string;
  device_token: string;
  profile_verification_status: boolean;
  login_verification_status: boolean;
  is_private: boolean;
  is_admin: boolean;
  platforms: string[];
  deleted_at: null;
  bloked_by_admin: boolean;
  contact_details: UserJoinedContactDetail[];
  createdAt: Date;
  updatedAt: Date;
}

export interface UserJoinedContactDetail {
  name: string;
  number: string;
  user_id: number;
}

// Receiving Call ==================================================================================
export interface ReceivingCallRes {
  call: ReceivingCall;
  user: ReceivingUser;
  chat: ReceivingChat;
}

export interface ReceivingCall {
  call_id: number;
  call_type: string;
  call_status: string;
  call_duration: number;
  start_time: Date;
  end_time: Date;
  users: string[];
  message_id: number;
  chat_id: number;
  user_id: number;
  room_id: string;
  current_users: string[];
  updatedAt: Date;
  createdAt: Date;
  caller_name: string;
}

export interface ReceivingChat {
  chat_id: number;
  chat_type: "group" | "private";
  group_icon: string;
  group_name: string;
  group_description: string;
  deleted_at: null;
  is_group_blocked: boolean;
  archived_for: string[];
  blocked_by: string[];
  cleared_for: string[];
  deleted_for: string[];
  createdAt: Date;
  updatedAt: Date;
  deletedAt: null;
}

export interface ReceivingUser {
  user_name: string;
  email: string;
  mobile_num: string;
  profile_pic: string;
  selfie: string;
  dob: string;
  user_id: number;
  first_name: string;
  last_name: string;
  full_name: string;
  country_code: string;
  socket_ids: string[];
  country: string;
  country_short_name: string;
  state: string;
  city: string;
  bio: string;
  device_token: string;
  profile_verification_status: boolean;
  login_verification_status: boolean;
  is_private: boolean;
  is_admin: boolean;
  deleted_at: null;
  bloked_by_admin: boolean;
  createdAt: Date;
  updatedAt: Date;
}

export interface ArchiveChatRes {
  success: boolean;
  chat_id: number;
  isArchived: boolean;
  message: string;
}


export interface BlockedUpdateRes {
  user_id: number;
  chat_id: number;
  is_blocked: boolean;
}


// CallEndedRes ==================================================================================
export interface CallEndedRes {
  call_id: number;
  call_type: string;
  call_status: string;
  call_duration: number;
  start_time: Date;
  end_time: Date;
  users: string[];
  current_users: string[];
  room_id: string;
  createdAt: Date;
  updatedAt: Date;
  message_id: number;
  chat_id: number;
  user_id: number;
  caller: Caller;
  peer_id: string;
}

export interface Caller {
  user_name: string;
  profile_pic: string;
  user_id: number;
  full_name: string;
}

// UpdateStoryRes ==================================================================================
export interface UpdateStoryRes {
  status: boolean;
  data: StoryUpdateData;
  message: string;
  toast: number;
}

export interface StoryUpdateData {
  media: string;
  thumbnail: string;
  expiresAt: Date;
  tagged: any[];
  views: any[];
  is_expired: boolean;
  story_id: number;
  story_type: string;
  caption: string;
  user_id: number;
  updatedAt: Date;
  createdAt: Date;
}

// NotificationlistRes ==================================================================================
export interface NotificationlistRes {
  status: boolean;
  data: NotificationData;
  message: string;
  toast: boolean;
}

export interface NotificationData {
  Records: NotificationRecord[];
  Pagination: Pagination;
}

export interface Pagination {
  total_pages: number;
  total_records: number;
  current_page: number;
  records_per_page: number;
}

export interface NotificationRecord {
  notification_id: number;
  title: string;
  message: string;
  users: any[];
  createdAt: Date;
  updatedAt: Date;
}
