export interface SearchChatListRes {
    status:  boolean;
    data:    Datum[];
    message: string;
    toast:   boolean;
}

export interface Datum {
    group_icon:        string;
    chat_id:           number;
    chat_type:         "group" | "private";
    group_name:        string;
    group_description: string;
    deleted_at:        Date;
    is_group_blocked:  boolean;
    archived_for:      string[];
    blocked_by:        string[];
    cleared_for:       string[];
    deleted_for:       string[];
    createdAt:         Date;
    updatedAt:         Date;
    deletedAt:         null;
    participants:      Participant[];
    Messages:          Message[];
}

export interface Message {
    message_content:      string;
    message_thumbnail:    string;
    reply_to:             number;
    social_id:            number;
    message_id:           number;
    message_type:         string;
    message_length:       string;
    message_seen_status:  string;
    message_size:         string;
    deleted_for:          string[];
    starred_for:          string[];
    deleted_for_everyone: boolean;
    pinned:               boolean;
    pin_lifetime:         string;
    peer_user:            null;
    pinned_till:          null;
    forwarded_from:       number;
    createdAt:            Date;
    updatedAt:            Date;
    chat_id:              number;
    sender_id:            number;
}

export interface Participant {
    participant_id:  number;
    is_admin:        boolean;
    update_counter:  boolean;
    is_deleted:      boolean;
    last_message_id: number;
    is_creator:      boolean;
    createdAt:       Date;
    updatedAt:       Date;
    chat_id:         number;
    user_id:         number;
    User:            User;
}

export interface User {
    user_name:   string;
    profile_pic: string;
    user_id:     number;
    first_name:  string;
    last_name:   string;
    full_name:   string;
    bio:         string;
}
