export interface StarMessageListRes {
  status:  boolean;
  data:    Data;
  message: string;
  toast:   number;
}

export interface Data {
  Records:    Record[];
  Pagination: Pagination;
}

export interface Pagination {
  total_pages:      number;
  total_records:    number;
  current_page:     number;
  records_per_page: number;
}

export interface Record {
  message_content:      string;
  message_thumbnail:    string;
  reply_to:             number;
  social_id:            number;
  message_id:           number;
  message_type:         string;
  message_length:       string;
  message_seen_status:  string;
  message_size:         string;
  deleted_for:          any[];
  starred_for:          string[];
  deleted_for_everyone: boolean;
  pinned:               boolean;
  pin_lifetime:         number | null;
  peer_user:            User;
  pinned_till:          Date | null;
  forwarded_from:       number;
  createdAt:            Date;
  updatedAt:            Date;
  chat_id:              number;
  sender_id:            number;
  story_id:             null;
  User:                 User;
  Chat:                 Chat;
}

export interface Chat {
  group_icon: string;
  chat_id:    number;
  chat_type:  string;
  group_name: string;
}

export interface User {
  user_name:                   string;
  email:                       string;
  profile_pic:                 string;
  user_id:                     number;
  full_name:                   string;
  country_code:                string;
  country:                     string;
  gender:                      string;
  bio:                         string;
  profile_verification_status: boolean;
  login_verification_status:   boolean;
  socket_ids:                  string[];
}
