export const getRandomColor = (userName: string, theme: string) => {
    const lightColors = [
      "#D32F2F", // strong red
      "#1976D2", // deep blue
      "#388E3C", // forest green
      "#7B1FA2", // deep purple
      "#F57C00", // burnt orange
      "#0288D1", // teal-blue
      "#C2185B", // magenta
      "#512DA8", // indigo
      "#00796B", // dark teal
    ]; // darker shades for visibility on light background

    const darkColors = [
      "#FF8A65", // light coral
      "#81C784", // mint green
      "#64B5F6", // sky blue
      "#BA68C8", // lavender purple
      "#FFD54F", // sunflower yellow
      "#4DB6AC", // aqua teal
      "#FFB74D", // warm orange
      "#E57373", // soft red
      "#9575CD", // light violet
    ]; // lighter shades for visibility on dark background

    const colors = theme == "dark" ? darkColors : lightColors;

    let hash = 0;
    for (let i = 0; i < userName.length; i++) {
      hash = userName.charCodeAt(i) + ((hash << 5) - hash);
    }
    return colors[Math.abs(hash) % colors.length];
  };
