export const socketQuery = (
  socket: any,
  eventName: any,
  payload: any,
  responseEventName: any,
) => {
  return new Promise((resolve, reject) => {
    socket.emit(eventName, payload);

    const timeout = setTimeout(() => {
      reject(new Error("Socket timeout"));
    }, 10000); // Optional timeout

    socket.once(responseEventName, (data: any) => {
      clearTimeout(timeout);
      resolve(data);
    });
  });
};
