// utils/themeColors.js
export const themeColors = [
    { id: 1, name: "Dark Green", hex: "#2E8B57" },
    { id: 2, name: "Light Green", hex: "#B4E7B4" },
    { id: 3, name: "Blue", hex: "#5B5FED" },
    { id: 4, name: "Light Lavender", hex: "#C7C5F3" },
    { id: 5, name: "Magenta", hex: "#A855D9" },
    { id: 6, name: "Light Pink/Lavender", hex: "#E5C7EF" },
    { id: 7, name: "Coral", hex: "#E76F51" },
    { id: 8, name: "Light Peach", hex: "#F4C7B7" },
    { id: 9, name: "Dark Teal", hex: "#1A7B7B" },
    { id: 10, name: "Cyan", hex: "#A7E0E0" },
    { id: 11, name: "Navy Blue", hex: "#2563EB" },
    { id: 12, name: "Light Blue", hex: "#BAD7F2" },
    { id: 13, name: "Dark Navy", hex: "#1E3A5F" },
    { id: 14, name: "Light Gray-Blue", hex: "#B8C5D6" },
    { id: 15, name: "Dark Green 2", hex: "#3D5A40" },
    { id: 16, name: "Light Sage", hex: "#C9D5C9" },
    { id: 17, name: "Burgundy", hex: "#6B1F3B" },
    { id: 18, name: "Light Pink", hex: "#F8C7DD" },
    { id: 19, name: "Black", hex: "#2D2D2D" },
    { id: 20, name: "Gray", hex: "#BDBDBD" },
    { id: 21, name: "Brown", hex: "#8B6F47" },
    { id: 22, name: "Beige", hex: "#F4E4D0" },
    { id: 23, name: "Tan", hex: "#B4A07A" },
    { id: 24, name: "Light Tan", hex: "#F0E9DD" },
    { id: 25, name: "Teal", hex: "#14B8A6" },
    { id: 26, name: "Light Cyan", hex: "#A7F3E8" },
    { id: 27, name: "Yellow", hex: "#FCC604" },
    { id: 28, name: "Light Yellow", hex: "#FEF3C7" },
    { id: 29, name: "Lime Green", hex: "#84CC16" },
    { id: 30, name: "Light Lime", hex: "#D9F99D" },
    { id: 31, name: "Pink", hex: "#EC4899" },
    { id: 32, name: "Light Pink 2", hex: "#FCE7F3" },
    { id: 33, name: "Red", hex: "#EF4444" },
    { id: 34, name: "Light Pink 3", hex: "#FECDD3" },
    { id: 35, name: "Orange", hex: "#F97316" },
    { id: 36, name: "Light Peach 2", hex: "#FED7AA" },
    { id: 37, name: "Gold", hex: "#D97706" },
    { id: 38, name: "Cream", hex: "#FEF3C7" },
].map((color) => ({
    ...color,
    textColor: getContrastTextColor(color.hex),
}));

// Helper function
export function getContrastTextColor(hex: string) {
    const rgb = parseInt(hex.slice(1), 16);
    const r = (rgb >> 16) & 0xff;
    const g = (rgb >> 8) & 0xff;
    const b = rgb & 0xff;

    // YIQ formula for brightness perception
    const brightness = (r * 299 + g * 587 + b * 114) / 1000;
    return brightness > 150 ? "#000000" : "#FFFFFF"; // dark text for light bg, white for dark bg
}
